package ru.yandex.solomon.roles;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import ru.yandex.solomon.acl.db.GroupMemberDao;
import ru.yandex.solomon.acl.db.model.GroupMember;
import ru.yandex.solomon.roles.idm.dto.IdmAddRoleDto;
import ru.yandex.solomon.roles.idm.dto.IdmRemoveRoleDto;
import ru.yandex.staff.StaffClient;

/**
 * @author Alexey Trushkin
 */
public class GroupMemberManager implements RoleChangeListener {

    private final GroupMemberDao dao;
    private final StaffClient staffClient;

    public GroupMemberManager(GroupMemberDao dao, StaffClient staffClient) {
        this.dao = dao;
        this.staffClient = staffClient;
    }

    private CompletableFuture<Void> updateNewGroup(Boolean exist, IdmAddRoleDto dto) {
        if (exist) {
            return CompletableFuture.completedFuture(null);
        }
        return staffClient.getStaffGroupMembers(dto.group)
                .thenCompose(staffGroupMembers -> {
                    var groupMembers = staffGroupMembers.stream()
                            .map(member -> new GroupMember(dto.group, member.login))
                            .collect(Collectors.toList());
                    return dao.create(groupMembers);
                });
    }

    @Override
    public CompletableFuture<Void> roleAdded(IdmAddRoleDto dto) {
        if (!dto.isGroup()) {
            return CompletableFuture.completedFuture(null);
        }
        return dao.exist(dto.group)
                .thenCompose(exist -> updateNewGroup(exist, dto));
    }

    @Override
    public CompletableFuture<Void> roleRemoved(IdmRemoveRoleDto dto) {
        if (!dto.isGroup() || !dto.delete) {
            return CompletableFuture.completedFuture(null);
        }
        return dao.deleteByGroupId(dto.group);
    }

}
