package ru.yandex.solomon.roles;

import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;

import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.locks.LockService;
import ru.yandex.solomon.locks.LockServiceImpl;
import ru.yandex.solomon.locks.dao.LocksDao;
import ru.yandex.solomon.locks.dao.ydb.YdbLocksDao;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;
import ru.yandex.solomon.util.host.HostUtils;

/**
 * @author Alexey Trushkin
 */
@Configuration
public class LockContext {

    @Bean(name = "gatewayLockService")
    LockService gatewayLockService(
            ThreadPoolProvider tpProvider,
            @Qualifier("gatewayLocksDao") LocksDao dao,
            MetricRegistry registry
    ) {
        ScheduledExecutorService timer = tpProvider.getSchedulerExecutorService();
        return new LockServiceImpl(HostUtils.getFqdn(), dao, Clock.systemUTC(), timer, registry);
    }

    @Bean(name = "gatewayLocksDao")
    LocksDao gatewayLocksDao(
            TableClient tableClient,
            MetricRegistry registry,
            @Qualifier("configKikimrRootPath") String rootPathStr
    ) {
        var rootPath = rootPathStr + "/Gateway/V1";
        YdbLocksDao dao = new YdbLocksDao(tableClient, Clock.systemUTC(), rootPath);
        dao.createSchema();
        return DaoMetricsProxy.of(dao, LocksDao.class, registry);
    }
}
