package ru.yandex.solomon.roles;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.roles.idm.dto.IdmAddRoleDto;
import ru.yandex.solomon.roles.idm.dto.IdmRemoveRoleDto;
import ru.yandex.solomon.roles.idm.dto.IdmResponseDto;
import ru.yandex.solomon.roles.idm.dto.IdmRoleTreeResponseDto;
import ru.yandex.solomon.roles.idm.dto.IdmRolesPageResponseDto;
import ru.yandex.solomon.roles.idm.dto.RoleDto;

/**
 * @author Alexey Trushkin
 */
public interface RoleManager {
    boolean accepts(RoleDto role);

    CompletableFuture<IdmResponseDto.ResultData> addRole(IdmAddRoleDto idmAddRoleDto);

    CompletableFuture<Void> removeRole(IdmRemoveRoleDto idmRemoveRoleDto);

    CompletableFuture<IdmRoleTreeResponseDto.RoleSubTree> getRoleSubTree();

    CompletableFuture<List<IdmRolesPageResponseDto.Role>> getRoles();
}
