package ru.yandex.solomon.roles.idm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.solomon.acl.db.model.AclUidType;

/**
 * @author Alexey Trushkin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class IdmOperationDto {

    public String login;
    public RoleDto role;
    public String group;
    public String subjectType;
    public String project;
    public AclUidType aclUidType;
    public String serviceProviderId;

    public boolean isUser() {
        return "user".equals(subjectType);
    }

    public boolean isTvm() {
        return "tvm_app".equals(subjectType);
    }

    public boolean isGroup() {
        return group != null;
    }

    public String getUid() {
        return isGroup() ? group : login;
    }

    @Override
    public String toString() {
        return "IdmAddRoleDto{" +
                "login='" + login + '\'' +
                ", role=" + role +
                ", group='" + group + '\'' +
                ", subjectType='" + subjectType + '\'' +
                ", project='" + project + '\'' +
                ", aclUidType=" + aclUidType +
                '}';
    }
}
