package ru.yandex.solomon.roles.idm.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.roles.idm.IdmException;

/**
 * @author Alexey Trushkin
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class IdmResponseDto {

    public static final int NO_AUTH_CODE = -1;

    @JsonProperty("code")
    public int code = 0;

    @JsonProperty("error")
    public String error;

    @JsonProperty("fatal")
    public String fatal;

    @JsonProperty("data")
    public ResultData data;

    public static IdmResponseDto ok() {
        return new IdmResponseDto();
    }

    public static IdmResponseDto ok(ResultData data) {
        var result = new IdmResponseDto();
        result.data = data;
        return result;
    }

    public static IdmResponseDto error(int code, String error) {
        var result = new IdmResponseDto();
        result.error = error;
        result.code = code;
        return result;
    }

    public static IdmResponseDto error(int code, IdmException exception) {
        var result = new IdmResponseDto();
        if (exception.isFatal()) {
            result.fatal = exception.getMessage();
        } else {
            result.error = exception.getMessage();
        }
        result.code = code;
        return result;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class ResultData {

        @JsonProperty("project")
        public String project;

        @JsonProperty("serviceProvider")
        public String serviceProvider;

        public static ResultData of(String project) {
            ResultData data = new ResultData();
            data.project = project;
            return data;
        }

        public static ResultData ofServiceProvider(String serviceProvider) {
            ResultData data = new ResultData();
            data.serviceProvider = serviceProvider;
            return data;
        }
    }
}
