package ru.yandex.solomon.roles.idm.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.solomon.acl.db.model.AclUidType;
import ru.yandex.solomon.acl.db.model.ProjectAclEntry;
import ru.yandex.solomon.acl.db.model.ServiceProviderAclEntry;
import ru.yandex.solomon.acl.db.model.SystemAclEntry;

/**
 * @author Alexey Trushkin
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class IdmRolesPageResponseDto extends IdmResponseDto {

    private static final Logger logger = LoggerFactory.getLogger(IdmRolesPageResponseDto.class);

    //TODO make pages
    @JsonProperty("roles")
    public List<Role> roles = new ArrayList<>();

    public static IdmRolesPageResponseDto ok(List<Role> roles) {
        var result = new IdmRolesPageResponseDto();
        result.roles = roles;
        result.code = 0;
        return result;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class Role {

        @JsonProperty("login")
        public String login;

        @JsonProperty("group")
        public Integer group;

        @JsonProperty("path")
        public String path;

        @JsonProperty("subject_type")
        public String subjectType;

        @JsonProperty("fields")
        public Map<String, String> fields;

        public static List<Role> createRoles(ProjectAclEntry entry) {
            List<Role> result = new ArrayList<>(entry.getRoles().size());
            for (String role : entry.getRoles()) {
                Role r = new Role();
                if (entry.getType() == AclUidType.TVM) {
                    r.subjectType = "tvm_app";
                    r.login = entry.getUid();
                } else if (entry.getType() == AclUidType.USER) {
                    r.subjectType = "user";
                    r.login = entry.getUid();
                } else {
                    try {
                        r.group = Integer.valueOf(entry.getUid());
                    } catch (NumberFormatException ex) {
                        logger.error("Group uid isn't a number", ex);
                        continue;
                    }
                }
                r.fields = Map.of("project", entry.getProjectId());
                r.path = "/type/project/role/" + role + "/";
                result.add(r);
            }
            return result;
        }

        public static List<Role> createRoles(SystemAclEntry entry) {
            List<Role> result = new ArrayList<>(entry.getRoles().size());
            for (String role : entry.getRoles()) {
                Role r = new Role();
                if (entry.getType() == AclUidType.TVM) {
                    r.subjectType = "tvm_app";
                    r.login = entry.getUid();
                } else if (entry.getType() == AclUidType.USER) {
                    r.subjectType = "user";
                    r.login = entry.getUid();
                } else {
                    try {
                        r.group = Integer.valueOf(entry.getUid());
                    } catch (NumberFormatException ex) {
                        logger.error("Group uid isn't a number", ex);
                        continue;
                    }
                }
                r.path = "/type/system/role/" + role + "/";
                result.add(r);
            }
            return result;
        }

        public static List<Role> createRoles(ServiceProviderAclEntry entry) {
            List<Role> result = new ArrayList<>(entry.getRoles().size());
            for (String role : entry.getRoles()) {
                Role r = new Role();
                if (entry.getType() == AclUidType.TVM) {
                    r.subjectType = "tvm_app";
                    r.login = entry.getUid();
                } else if (entry.getType() == AclUidType.USER) {
                    r.subjectType = "user";
                    r.login = entry.getUid();
                } else {
                    try {
                        r.group = Integer.valueOf(entry.getUid());
                    } catch (NumberFormatException ex) {
                        logger.error("Group uid isn't a number", ex);
                        continue;
                    }
                }
                r.fields = Map.of("serviceProvider", entry.getServiceProviderId());
                r.path = "/type/service_provider/role/" + role + "/";
                result.add(r);
            }
            return result;
        }
    }

}
