package ru.yandex.solomon.roles.idm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author Alexey Trushkin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class RoleDto {

    public Type type;
    @JsonProperty("role")
    public String roleId;

    public boolean isProject() {
        return Type.PROJECT.equals(type);
    }

    public boolean isServiceProvider() {
        return Type.SERVICE_PROVIDER.equals(type);
    }

    public boolean isSystem() {
        return Type.SYSTEM.equals(type);
    }

    @Override
    public String toString() {
        return "RoleDto{" +
                "type='" + type + '\'' +
                ", roleId='" + roleId + '\'' +
                '}';
    }

    public enum Type {
        PROJECT,
        SYSTEM,
        SERVICE_PROVIDER;

        @JsonValue
        public String value() {
            return this.toString().toLowerCase();
        }
    }
}
