package ru.yandex.solomon.role;

import ru.yandex.solomon.acl.db.model.AclUidType;
import ru.yandex.solomon.roles.idm.dto.IdmAddRoleDto;
import ru.yandex.solomon.roles.idm.dto.IdmRemoveRoleDto;
import ru.yandex.solomon.roles.idm.dto.RoleDto;

/**
 * @author Alexey Trushkin
 */
class DtoFactory {

    static final String GROUP = "123";
    static final String USER = "user 1";
    static final String UID = "some id 1";
    static final String ROLE_ID = "editor";
    static final String ROLE_ID2 = "reader";
    static final String ROLE_ID3 = "god";

    static IdmAddRoleDto idmAddRoleDto(String roleId) {
        return idmAddRoleDto(roleId, UID, null);
    }

    static IdmAddRoleDto idmAddRoleDto(String roleId, String projectId, String serviceProvider) {
        RoleDto role = new RoleDto();
        role.type = RoleDto.Type.PROJECT;
        role.roleId = roleId;
        IdmAddRoleDto result = new IdmAddRoleDto();
        result.group = GROUP;
        result.project = projectId;
        result.serviceProviderId = serviceProvider;
        result.role = role;
        result.aclUidType = AclUidType.GROUP;
        return result;
    }

    static IdmAddRoleDto idmAddSystemRoleDto(String roleId) {
        RoleDto role = new RoleDto();
        role.type = RoleDto.Type.SYSTEM;
        role.roleId = roleId;
        IdmAddRoleDto result = new IdmAddRoleDto();
        result.group = USER;
        result.role = role;
        result.aclUidType = AclUidType.USER;
        return result;
    }

    static IdmAddRoleDto idmAddUserRoleDto(String roleId) {
        return idmAddUserRoleDto(roleId, USER);
    }

    static IdmAddRoleDto idmAddUserRoleDto(String roleId, String user) {
        RoleDto role = new RoleDto();
        role.type = RoleDto.Type.PROJECT;
        role.roleId = roleId;
        IdmAddRoleDto result = new IdmAddRoleDto();
        result.login = user;
        result.project = UID;
        result.role = role;
        result.aclUidType = AclUidType.USER;
        return result;
    }

    static IdmRemoveRoleDto idmRemoveRoleDto(String roleId) {
        RoleDto role = new RoleDto();
        role.type = RoleDto.Type.PROJECT;
        role.roleId = roleId;
        IdmRemoveRoleDto result = new IdmRemoveRoleDto();
        result.group = GROUP;
        result.project = UID;
        result.role = role;
        result.aclUidType = AclUidType.GROUP;
        result.delete = true;
        return result;
    }

    static IdmRemoveRoleDto idmRemoveRoleDtoSp(String roleId) {
        RoleDto role = new RoleDto();
        role.type = RoleDto.Type.PROJECT;
        role.roleId = roleId;
        IdmRemoveRoleDto result = new IdmRemoveRoleDto();
        result.group = GROUP;
        result.serviceProviderId = UID;
        result.role = role;
        result.aclUidType = AclUidType.GROUP;
        result.delete = true;
        return result;
    }

    static IdmRemoveRoleDto idmRemoveSystemRoleDto(String roleId) {
        RoleDto role = new RoleDto();
        role.type = RoleDto.Type.SYSTEM;
        role.roleId = roleId;
        IdmRemoveRoleDto result = new IdmRemoveRoleDto();
        result.group = USER;
        result.role = role;
        result.aclUidType = AclUidType.USER;
        result.delete = true;
        return result;
    }

    static IdmRemoveRoleDto idmRemoveUserRoleDto(String roleId) {
        return idmRemoveUserRoleDto(roleId, USER);
    }

    static IdmRemoveRoleDto idmRemoveUserRoleDto(String roleId, String user) {
        RoleDto role = new RoleDto();
        role.type = RoleDto.Type.PROJECT;
        role.roleId = roleId;
        IdmRemoveRoleDto result = new IdmRemoveRoleDto();
        result.login = user;
        result.project = UID;
        result.role = role;
        result.aclUidType = AclUidType.USER;
        return result;
    }
}
