package ru.yandex.solomon.role;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.solomon.acl.db.memory.InMemoryGroupMemberDao;
import ru.yandex.solomon.acl.db.model.GroupMember;
import ru.yandex.solomon.roles.GroupMemberManager;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.role.DtoFactory.idmAddRoleDto;
import static ru.yandex.solomon.role.DtoFactory.idmAddUserRoleDto;
import static ru.yandex.solomon.role.DtoFactory.idmRemoveRoleDto;
import static ru.yandex.solomon.role.DtoFactory.idmRemoveUserRoleDto;
import static ru.yandex.solomon.role.StaffClientStub.GROUP_ID1;
import static ru.yandex.solomon.role.StaffClientStub.USER_ID1;
import static ru.yandex.solomon.role.StaffClientStub.USER_ID2;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class GroupMemberManagerTest {

    private GroupMemberManager manager;
    private InMemoryGroupMemberDao dao;

    @Before
    public void before() {
        dao = new InMemoryGroupMemberDao();
        manager = new GroupMemberManager(dao, new StaffClientStub());
    }

    @Test
    public void roleRemoved_forUser() {
        createSync(groupMember(USER_ID1, GROUP_ID1));
        assertFalse(findByGroupIdSync(GROUP_ID1).isEmpty());

        join(manager.roleRemoved(idmRemoveUserRoleDto("")));
        assertFalse(findByGroupIdSync(GROUP_ID1).isEmpty());
    }

    @Test
    public void roleRemoved_forGroup() {
        createSync(groupMember(USER_ID1, GROUP_ID1));
        assertFalse(findByGroupIdSync(GROUP_ID1).isEmpty());

        join(manager.roleRemoved(idmRemoveRoleDto("")));
        assertTrue(findByGroupIdSync(GROUP_ID1).isEmpty());
    }

    @Test
    public void roleAdded_forUser() {
        assertTrue(findByGroupIdSync(GROUP_ID1).isEmpty());

        join(manager.roleAdded(idmAddUserRoleDto("")));
        assertTrue(findByGroupIdSync(GROUP_ID1).isEmpty());
    }

    @Test
    public void roleAdded_forGroup() {
        assertTrue(findByGroupIdSync(GROUP_ID1).isEmpty());

        join(manager.roleAdded(idmAddRoleDto("")));
        List<GroupMember> actual = findByGroupIdSync(GROUP_ID1);
        assertEquals(actual.size(), 2);
        assertTrue(actual.contains(groupMember(USER_ID1, GROUP_ID1)));
        assertTrue(actual.contains(groupMember(USER_ID2, GROUP_ID1)));
    }

    private List<GroupMember> findByGroupIdSync(String groupId) {
        return join(dao.find(groupId));
    }

    private void createSync(GroupMember groupMember) {
        join(dao.create(List.of(groupMember)));
    }

    private GroupMember groupMember(String userId, String groupId) {
        return new GroupMember(groupId, userId);
    }

}
