package ru.yandex.solomon.search;

import java.util.List;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.search.roaring.BitmapIndex;


/**
 * Results (from solomon-dev-myt-00)
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 * Benchmark                                   Mode  Cnt    Score     Error  Units
 * IndexBuildBenchmark.buildOwn                avgt   10  900.996 ± 133.910  ms/op
 * IndexBuildBenchmark.buildRoaring            avgt   10  763.472 ±  67.709  ms/op
 * IndexBuildBenchmark.buildRoaringSerialized  avgt   10  837.050 ±  45.950  ms/op
 *
 * @author Sergey Polovko
 */
@Fork(value = 1)
@Warmup(iterations = 20)
@Measurement(iterations = 10)
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.MILLISECONDS)
public class IndexBuildBenchmark {

    private static final List<Labels> METRICS = StubMetrics.generate(2_000_000);

    @Benchmark
    public BitmapIndex buildBitmap() {
        return BitmapIndex.build(METRICS);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(IndexBuildBenchmark.class.getSimpleName())
            .detectJvmArgs()
            .jvmArgs("-Xmx2g", "-Xms2g")
            .build();

        new Runner(opt).run();
    }
}
