package ru.yandex.solomon.search;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.search.roaring.BitmapIndex;


/**
 * Results (from solomon-dev-myt-00)
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 * Benchmark                                    Mode  Cnt    Score   Error   Units
 * IndexLabelNamesBenchmark.own                thrpt   10  332.452 ± 4.155  ops/us
 * IndexLabelNamesBenchmark.roaring            thrpt   10  352.361 ± 1.596  ops/us
 * IndexLabelNamesBenchmark.roaringSerialized  thrpt   10  335.257 ± 3.744  ops/us
 *
 * @author Sergey Polovko
 */
@Fork(value = 1)
@Warmup(iterations = 20)
@Measurement(iterations = 10)
@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.MICROSECONDS)
public class IndexLabelNamesBenchmark {

    private static List<Labels> metrics = StubMetrics.generate(1_000_000);
    private static SearchIndex roaringIndex = BitmapIndex.build(metrics);

    @Benchmark
    public Set<String> roaring() {
        return roaringIndex.labelNames();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(IndexLabelNamesBenchmark.class.getName())
            .detectJvmArgs()
            .jvmArgs("-Xmx2g", "-Xms2g")
            .build();

        new Runner(opt).run();
    }
}
