package ru.yandex.solomon.search;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.search.roaring.BitmapIndex;
import ru.yandex.solomon.util.labelStats.LabelValuesStats;


/**
 * Results (from solomon-dev-myt-00)
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 * Benchmark                                    Mode  Cnt        Score         Error  Units
 * IndexLabelStatsBenchmark.own                thrpt   10       80.192 ±       6.321  ops/s
 * IndexLabelStatsBenchmark.roaring            thrpt   10  3190338.478 ± 1161633.687  ops/s
 * IndexLabelStatsBenchmark.roaringSerialized  thrpt   10  5224771.954 ±  405448.060  ops/s
 *
 * @author Sergey Polovko
 */
@Fork(value = 1)
@Warmup(iterations = 20)
@Measurement(iterations = 10)
@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.SECONDS)
public class IndexLabelStatsBenchmark {

    private static List<Labels> metrics = StubMetrics.generate(1_000_000);
    private static SearchIndex roaringIndex = BitmapIndex.build(metrics);

    @Benchmark
    public LabelValuesStats roaring() {
        return roaringIndex.labelStats(Collections.emptySet());
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(IndexLabelStatsBenchmark.class.getName())
            .detectJvmArgs()
            .jvmArgs("-Xmx2g", "-Xms2g")
            .build();

        new Runner(opt).run();
    }
}
