package ru.yandex.solomon.search;

import java.util.List;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.search.roaring.BitmapIndex;


/**
 * Run
 * ~~~
 *
 * $ ./run.sh ru.yandex.solomon.search.IndexSizeBenchmark -Xmx4g -Xms4g > results.txt
 *
 * Results (from solomon-dev-myt-00)
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 * count:       1000, roaring:      13920, roaringSerialized:       8445
 * count:      10000, roaring:      45776, roaringSerialized:      38817
 * count:     100000, roaring:     187488, roaringSerialized:     178458
 * count:    1000000, roaring:    1533472, roaringSerialized:    1485030
 * count:   10000000, roaring:   14913336, roaringSerialized:   14488964
 *
 * @author Sergey Polovko
 */
public class IndexSizeBenchmark {

    public static void main(String[] args) {
        for (int count = 1_000; count <= 10_000_000; count *= 10) {
            System.err.println("generating " + count + " metrics");
            List<Labels> metrics = StubMetrics.generate(count);

            System.err.println("build BitmapIndex");
            long roaringSize = BitmapIndex.build(metrics).getIndexSize();

            System.out.printf("count: %10d, roaring: %10d\n", count, roaringSize);
        }
    }
}
