package ru.yandex.solomon.search;

import java.util.Random;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.roaringbitmap.RoaringBitmap;


/**
 * results from solomon-dev-myt-00.search.yandex.net
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 * Benchmark                                     Mode  Cnt      Score     Error  Units
 * RoaringBitmapBenchmark.lazyOr                thrpt   10   6761.846 ± 545.446  ops/s
 * RoaringBitmapBenchmark.lazyOrNotRepair       thrpt   10   6489.671 ±  71.281  ops/s
 * RoaringBitmapBenchmark.naiveLazyOr           thrpt   10   1324.728 ±  76.616  ops/s
 * RoaringBitmapBenchmark.naiveLazyOrNotRepair  thrpt   10  29282.715 ± 673.392  ops/s
 * RoaringBitmapBenchmark.or                    thrpt   10   6356.974 ± 530.459  ops/s
 *
 * @author Sergey Polovko
 */
@Fork(value = 1)
@Warmup(iterations = 20)
@Measurement(iterations = 10)
@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.SECONDS)
public class RoaringBitmapBenchmark {

    private static final Random RND = new Random(17);
    private static final Bitmap b1 = new Bitmap();
    private static final Bitmap b2 = new Bitmap();

    static {
        for (int i = 0; i < 10_000; i++) {
            b1.add(RND.nextInt(10_000_000));
        }
        for (int i = 0; i < 10_000; i++) {
            b2.add(RND.nextInt(10_000_000));
        }
        b1.runOptimize();
        b2.runOptimize();
    }

    @Benchmark
    public RoaringBitmap naiveLazyOr() {
        b1.naiveLazyOr(b2);
        return b1;
    }

    @Benchmark
    public RoaringBitmap naiveLazyOrNotRepair() {
        b1.naiveLazyOrNotRepair(b2);
        return b1;
    }

    @Benchmark
    public RoaringBitmap lazyOr() {
        b1.lazyOr(b2);
        return b1;
    }

    @Benchmark
    public RoaringBitmap lazyOrNotRepair() {
        b1.lazyOrNotRepair(b2);
        return b1;
    }

    @Benchmark
    public RoaringBitmap or() {
        b1.or(b2);
        return b1;
    }

    // To access protected methods
    private static final class Bitmap extends RoaringBitmap {
        void naiveLazyOr(Bitmap b) {
            naivelazyor(b);
            repairAfterLazy();
        }

        void naiveLazyOrNotRepair(Bitmap b) {
            naivelazyor(b);
        }

        void lazyOr(Bitmap b) {
            lazyor(b);
            repairAfterLazy();
        }

        void lazyOrNotRepair(Bitmap b) {
            lazyor(b);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(RoaringBitmapBenchmark.class.getName())
            .detectJvmArgs()
            .jvmArgs("-Xmx1g", "-Xms1g")
            .build();

        new Runner(opt).run();
    }
}
