package ru.yandex.solomon.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.query.Selectors;


/**
 * @author Sergey Polovko
 */
final class StubMetrics {
    private StubMetrics() {}

    static List<Labels> generate(int count) {
        return generate(count, new Random(17));
    }

    static List<Labels> generate(int count, Random rnd) {
        System.err.println("generate " + count + " metrics");
        Tuple2List<String, Integer> labels = Tuple2List.fromPairs(
            "host", 4,
            "partition", 6,
            "sensor", 10,
            "info", 15,
            "servant", 31,
            "yyy", 60,
            "xxx", 52);
        return LabeledStub.buildRandomMetricKeyStream(labels, rnd)
            .limit(count)
            .collect(Collectors.toList());
    }

    static List<Labels> generateManyUniqueValues(int count) {
        return generateManyUniqueValues(count, new Random(17));
    }

    static List<Labels> generateManyUniqueValues(int count, Random rnd) {
        System.err.println("generate " + count + " metrics");
        Tuple2List<String, Integer> labels = Tuple2List.fromPairs(
            "host", 4,
            "sensor", count / 4);
        return LabeledStub.buildRandomMetricKeyStream(labels, rnd)
            .limit(count)
            .collect(Collectors.toList());
    }

    static Selectors generateSelectors(List<Labels> metrics, int valuesCount) {
        return generateSelectors(metrics, valuesCount, new Random(17));
    }

    static Selectors generateSelectors(List<Labels> metrics, int valuesCount, Random rnd) {
        if (valuesCount == 1) {
            return Selectors.of(metrics.get(rnd.nextInt(metrics.size())));
        }

        Map<String, String> selectors = new HashMap<>();
        for (int i = 0; i < valuesCount; i++) {
            Labels labels = metrics.get(rnd.nextInt(metrics.size()));
            labels.forEach(l -> selectors.compute(l.getKey(), (key, value) -> {
                if (value == null) {
                    return l.getValue();
                }
                return value + '|' + l.getValue();
            }));
        }
        return Selectors.of(selectors);
    }
}
