package ru.yandex.solomon.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.random.Random2;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;


/**
* @author Stepan Koltsov
*/
@ParametersAreNonnullByDefault
public class LabeledStub {

    private static String[] buildRandomLabelValues(int num, Random2 random2) {
        HashSet<String> result = new HashSet<>();
        while (result.size() != num) {
            String keyValue = random2.nextString(10);
            result.add(keyValue);
        }

        return result.toArray(new String[num]);
    }

    public static Stream<Labels> buildRandomMetricKeyStream(Tuple2List<String, Integer> labelsAndSizes, Random random) {
        Random2 r2 = new Random2(random);
        String[] labelNames = labelsAndSizes.get1().toArray(String.class);
        String[][] labels = labelsAndSizes.get2().map(num -> buildRandomLabelValues(num, r2)).toArray(String[].class);

        int numKeys = Arrays.stream(labels).mapToInt(x -> x.length).reduce(1, (a, b) -> a * b);

        return IntStream.range(0, numKeys).mapToObj(idx -> {
            LabelsBuilder builder = Labels.builder(labelNames.length);
            for (int i = 0; i < labelNames.length; i++) {
                builder.add(labelNames[i], labels[i][idx % labels[i].length]);
                idx /= labels[i].length;
            }
            return builder.build();
        });
    }
}
