package ru.yandex.solomon.search;

import java.util.Collection;
import java.util.Iterator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.search.roaring.BitmapIndex;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface SearchEngine {

    SearchEngine defaultSearchEngine = new SearchEngine() {
        @Override
        public SearchIndex build(Collection<Labels> targets) {
            return BitmapIndex.build(targets);
        }

        @Override
        public SearchIndex build(Iterator<Labels> targets) {
            return BitmapIndex.build(targets);
        }
    };

    SearchIndex build(Collection<Labels> targets);

    SearchIndex build(Iterator<Labels> targets);
}
