package ru.yandex.solomon.search;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.search.result.SearchResult;
import ru.yandex.solomon.util.labelStats.LabelValuesStats;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface SearchIndex extends MemMeasurable {

    default SearchResult search(Selectors selectors) {
        return search(selectors, Integer.MAX_VALUE);
    }

    SearchResult search(Selectors selectors, int max);

    ImmutableSet<String> labelNames();

    LabelValuesStats labelStats(Set<String> requestedNames);

    long getIndexSize();

    long getIndexCacheSize();

    @Override
    default long memorySizeIncludingSelf() {
        return getIndexSize();
    }
}
