package ru.yandex.solomon.search.result;

import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.stream.Stream;


/**
 * @author Sergey Polovko
 */
public class ArrayResult implements SearchResult {

    private final int[] ints;

    public ArrayResult(int[] ints) {
        this.ints = ints;
    }

    @Override
    public <T> Stream<T> mapToObj(IntFunction<? extends T> mapper) {
        return Arrays.stream(ints)
            .mapToObj(mapper);
    }

    @Override
    public int size() {
        return ints.length;
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(ints, ints.length);
    }
}
