package ru.yandex.solomon.search.result;

import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;


/**
 * @author Sergey Polovko
 */
public class RangeResult implements SearchResult {

    private final int fromInclusive;
    private final int toExclusive;

    public RangeResult(int fromInclusive, int toExclusive) {
        if (fromInclusive >= toExclusive) {
            String msg = String.format("fromInclusive(%d) >= toExclusive(%d)", fromInclusive, toExclusive);
            throw new IllegalArgumentException(msg);
        }
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
    }

    @Override
    public <T> Stream<T> mapToObj(IntFunction<? extends T> mapper) {
        return IntStream.range(fromInclusive, toExclusive)
            .mapToObj(mapper);
    }

    @Override
    public int size() {
        return toExclusive - fromInclusive;
    }

    @Override
    public int[] toArray() {
        int[] result = new int[toExclusive - fromInclusive];
        for (int id = fromInclusive, i = 0; id < toExclusive; id++, i++) {
            result[i] = id;
        }
        return result;
    }
}
