package ru.yandex.solomon.search.roaring;

import java.util.Arrays;
import java.util.stream.IntStream;

import ru.yandex.solomon.memory.layout.MemoryCounter;


/**
 * @author Sergey Polovko
 */
final class ArrayBitmap implements Bitmap {

    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(ArrayBitmap.class);

    private final int[] ints;

    ArrayBitmap(int... ints) {
        this.ints = ints;
    }

    @Override
    public long memorySize() {
        return SELF_SIZE + MemoryCounter.arrayObjectSize(ints);
    }

    @Override
    public int size() {
        return ints.length;
    }

    @Override
    public IntStream toIntStream(int maxSize) {
        if (maxSize == 0) {
            return IntStream.empty();
        }
        return Arrays.stream(ints, 0, Math.min(maxSize, ints.length));
    }

    @Override
    public void addTo(RoaringBitmap x) {
        x.add(ints);
    }

    @Override
    public void removeFrom(RoaringBitmap x) {
        for (int i : ints) {
            x.remove(i);
        }
    }

    @Override
    public String toString() {
        return "ArrayBitmap{" + Arrays.toString(ints) + '}';
    }
}
