package ru.yandex.solomon.search.roaring;

import java.util.function.IntFunction;
import java.util.stream.Stream;

import ru.yandex.solomon.search.result.SearchResult;


/**
 * @author Sergey Polovko
 */
final class BitmapResult implements SearchResult {

    private final Bitmap bitmap;
    private final int size;

    BitmapResult(Bitmap bitmap, int limit) {
        this.bitmap = bitmap;
        this.size = Math.min(bitmap.size(), limit);
    }

    @Override
    public <T> Stream<T> mapToObj(IntFunction<? extends T> mapper) {
        return bitmap.toIntStream(size).mapToObj(mapper);
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public int[] toArray() {
        return bitmap.toIntStream(size).toArray();
    }
}
