package ru.yandex.solomon.search.roaring;

import java.util.stream.IntStream;


/**
 * @author Sergey Polovko
 */
final class EmptyBitmap implements Bitmap {

    static final EmptyBitmap INSTANCE = new EmptyBitmap();

    private EmptyBitmap() {
    }

    @Override
    public long memorySize() {
        return 0;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public IntStream toIntStream(int maxSize) {
        return IntStream.empty();
    }

    @Override
    public void addTo(RoaringBitmap x) {
    }

    @Override
    public void removeFrom(RoaringBitmap x) {
    }
}
