package ru.yandex.solomon.search.roaring;

import java.lang.reflect.Field;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringArray;


/**
 * @author Sergey Polovko
 */
final class RoaringBitmap extends org.roaringbitmap.RoaringBitmap implements Bitmap {

    private static final Field containerField;
    static {
        try {
            containerField = RoaringBitmap.class.getSuperclass().getDeclaredField("highLowContainer");
            containerField.setAccessible(true);
        } catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    RoaringBitmap() {
        super();
    }

    static RoaringBitmap copyOf(Bitmap bitmap) {
        RoaringBitmap bitmapCopy = new RoaringBitmap();
        if (bitmap instanceof RoaringBitmap) {
            try {
                RoaringArray arrayCopy = ((RoaringArray) containerField.get(bitmap)).clone();
                containerField.set(bitmapCopy, arrayCopy);
                return bitmapCopy;
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            bitmap.addTo(bitmapCopy);
        }
        return bitmapCopy;
    }

    @Override
    public long memorySize() {
        // non precise estimation
        return getLongSizeInBytes();
    }

    @Override
    public int size() {
        return getCardinality();
    }

    @Override
    public boolean isEmpty() {
        return size() == 0;
    }

    @Override
    public String toString() {
        return "RoaringBitmap" + super.toString();
    }

    void lazyOr(RoaringBitmap x) {
        naivelazyor(x);
    }

    void repairAfterLazyOr() {
        repairAfterLazy();
    }

    void and(Bitmap x) {
        if (x instanceof RoaringBitmap) {
            super.and((RoaringBitmap) x);
        } else {
            super.and(RoaringBitmap.copyOf(x));
        }
    }

    @Override
    public IntStream toIntStream(int maxSize) {
        final int characteristics = Spliterator.ORDERED
            | Spliterator.DISTINCT
            | Spliterator.SORTED
            | Spliterator.SIZED
            | Spliterator.SUBSIZED;

        Spliterator.OfInt spliterator = Spliterators.spliterator(
            new IntIteratorAdapter(getIntIterator(), maxSize),
            maxSize,
            characteristics);
        return StreamSupport.intStream(spliterator, false);
    }

    @Override
    public void addTo(RoaringBitmap x) {
        x.or(this);
    }

    @Override
    public void removeFrom(RoaringBitmap x) {
        x.andNot(this);
    }

    /**
     * INT ITERATOR ADAPTER
     */
    private static class IntIteratorAdapter implements PrimitiveIterator.OfInt {
        private final PeekableIntIterator it;
        private int limit;

        IntIteratorAdapter(PeekableIntIterator it, int limit) {
            this.it = it;
            this.limit = limit;
        }

        @Override
        public int nextInt() {
            --limit;
            return it.next();
        }

        @Override
        public boolean hasNext() {
            return limit > 0 && it.hasNext();
        }
    }
}
