package ru.yandex.solomon.search.roaring;

import java.util.stream.IntStream;

import ru.yandex.solomon.memory.layout.MemoryCounter;


/**
 * @author Sergey Polovko
 */
final class SingleBitmap implements Bitmap {

    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(SingleBitmap.class);

    private final int value;

    SingleBitmap(int value) {
        this.value = value;
    }

    @Override
    public long memorySize() {
        return SELF_SIZE;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public IntStream toIntStream(int maxSize) {
        if (maxSize == 0) {
            return IntStream.empty();
        }
        return IntStream.of(value);
    }

    @Override
    public void addTo(RoaringBitmap x) {
        x.add(value);
    }

    @Override
    public void removeFrom(RoaringBitmap x) {
        x.remove(value);
    }

    @Override
    public String toString() {
        return "SingleBitmap{" + value + '}';
    }
}
