package ru.yandex.solomon.search.result;

import org.junit.Assert;
import org.junit.Test;


/**
 * @author Sergey Polovko
 */
public class RangeResultTest {

    @Test
    public void one() {
        RangeResult stream = new RangeResult(0, 1);
        Assert.assertEquals(1, stream.size());
        Assert.assertArrayEquals(new int[] { 0 }, stream.toArray());
        Assert.assertArrayEquals(
            new String[] { "0" },
            stream.mapToObj(Integer::toString).toArray());
    }

    @Test
    public void many() {
        RangeResult stream = new RangeResult(0, 4);
        Assert.assertEquals(4, stream.size());
        Assert.assertArrayEquals(new int[] { 0, 1, 2, 3 }, stream.toArray());
        Assert.assertArrayEquals(
            new String[] { "0", "1", "2", "3" },
            stream.mapToObj(Integer::toString).toArray());
    }

    @Test
    public void manyWithNonZeroFrom() {
        RangeResult stream = new RangeResult(10, 15);
        Assert.assertEquals(5, stream.size());
        Assert.assertArrayEquals(new int[] { 10, 11, 12, 13, 14 }, stream.toArray());
        Assert.assertArrayEquals(
            new String[] { "10", "11", "12", "13", "14" },
            stream.mapToObj(Integer::toString).toArray());
    }

    @Test
    public void invalidRange() {
        try {
            new RangeResult(0, 0);
            Assert.fail("expected exception was not thrown");
        } catch (IllegalArgumentException e) {
            Assert.assertEquals("fromInclusive(0) >= toExclusive(0)", e.getMessage());
        }

        try {
            new RangeResult(2, 0);
            Assert.fail("expected exception was not thrown");
        } catch (IllegalArgumentException e) {
            Assert.assertEquals("fromInclusive(2) >= toExclusive(0)", e.getMessage());
        }
    }
}
