package ru.yandex.solomon.search.roaring;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.search.result.SearchResult;


/**
 * @author Sergey Polovko
 */
public class BitmapResultTest {

    @Test
    public void empty() {
        RoaringBitmap bitmap = new RoaringBitmap();

        SearchResult stream = Bitmaps.toSearchResult(bitmap, Integer.MAX_VALUE);
        Assert.assertEquals(0, stream.size());
        Assert.assertArrayEquals(new int[] {}, stream.toArray());
        Assert.assertArrayEquals(new String[] {}, stream.mapToObj(Integer::toString).toArray());
    }

    @Test
    public void one() {
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.add(42);

        SearchResult stream = Bitmaps.toSearchResult(bitmap, Integer.MAX_VALUE);
        Assert.assertEquals(1, stream.size());
        Assert.assertArrayEquals(new int[] { 42 }, stream.toArray());
        Assert.assertArrayEquals(new String[] { "42" }, stream.mapToObj(Integer::toString).toArray());
    }

    @Test
    public void many() {
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.add(42);
        bitmap.add(37);
        bitmap.add(51);

        SearchResult stream = Bitmaps.toSearchResult(bitmap, Integer.MAX_VALUE);
        Assert.assertEquals(3, stream.size());
        Assert.assertArrayEquals(new int[] { 37, 42, 51 }, stream.toArray());
        Assert.assertArrayEquals(new String[] { "37", "42", "51" }, stream.mapToObj(Integer::toString).toArray());
    }

    @Test
    public void manyWitLimit() {
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.add(1);
        bitmap.add(2);
        bitmap.add(3);
        bitmap.add(4);
        bitmap.add(5);

        // limit < cardinality
        {
            SearchResult stream = Bitmaps.toSearchResult(bitmap, 3);
            Assert.assertEquals(3, stream.size());
            Assert.assertArrayEquals(new int[]{ 1, 2, 3 }, stream.toArray());
            Assert.assertArrayEquals(new String[]{ "1", "2", "3" }, stream.mapToObj(Integer::toString).toArray());
        }

        // limit == cardinality
        {
            SearchResult stream = Bitmaps.toSearchResult(bitmap, 5);
            Assert.assertEquals(5, stream.size());
            Assert.assertArrayEquals(new int[]{ 1, 2, 3, 4, 5 }, stream.toArray());
            Assert.assertArrayEquals(new String[]{ "1", "2", "3", "4", "5" }, stream.mapToObj(Integer::toString).toArray());
        }

        // limit > cardinality
        {
            SearchResult stream = Bitmaps.toSearchResult(bitmap, 100);
            Assert.assertEquals(5, stream.size());
            Assert.assertArrayEquals(new int[]{ 1, 2, 3, 4, 5 }, stream.toArray());
            Assert.assertArrayEquals(new String[]{ "1", "2", "3", "4", "5" }, stream.mapToObj(Integer::toString).toArray());
        }
    }
}
