package ru.yandex.solomon.search.roaring;

import java.util.Arrays;
import java.util.Random;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.junit.Test;

import ru.yandex.misc.test.Assert;


/**
 * @author Sergey Polovko
 */
public class RoaringBitmapTest {

    private static final Random RND = new Random(17);

    @Test
    public void addTo() {
        for (int i = 10; i < 1000; i++) {
            RoaringBitmap bm1 = new RoaringBitmap();
            IntOpenHashSet set1 = new IntOpenHashSet();
            fillRandom(bm1, set1, i);

            RoaringBitmap bm2 = new RoaringBitmap();
            IntOpenHashSet set2 = new IntOpenHashSet();
            fillRandom(bm2, set2, i);

            int rndValue = RND.nextInt(i);

            bm2.addTo(bm1);
            bm1.add(rndValue);

            set1.addAll(set2);
            set1.add(rndValue);

            int[] expected = set1.toIntArray();
            Arrays.sort(expected);

            Assert.arraysEquals(expected, bm1.toArray());
        }
    }

    private static void fillRandom(RoaringBitmap bm, IntOpenHashSet set, int count) {
        for (int i = 0; i < count; i++) {
            int value = RND.nextInt(10 * count);
            bm.add(value);
            set.add(value);
        }
    }
}
