package ru.yandex.solomon.secrets;

import java.nio.file.Path;
import java.util.Optional;

/**
 * @author Sergey Polovko
 */
public final class SecretProviders {
    private SecretProviders() {}

    /**
     * Create secret provider which always returns empty values.
     *
     * @return new instance of secret provider
     */
    public static SecretProvider empty() {
        return key -> Optional.empty();
    }

    /**
     * Create secret provider which returns secret directly inlined in configuration file.
     *
     * @return new instance of secret provider
     */
    public static SecretProvider inline() {
        return Optional::of;
    }

    /**
     * Create secret provider which has secrets loaded from given file.
     *
     * @param path   path of the file with secrets
     * @return new instance of secret provider
     */
    public static SecretProvider fromFile(Path path) {
        return SecretProviderImpl.fromFile(path);
    }

    /**
     * Create secret provider which has secrets loaded from given file.
     *
     * @param content   secrets content
     * @return new instance of secret provider
     */
    public static SecretProvider fromString(String content) {
        return SecretProviderImpl.fromString(content);
    }
}
