package ru.yandex.solomon.secrets;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Sergey Polovko
 */
public class SecretProviderTest {

    @Test
    public void parseNormalStyleProto() {
        var provider = SecretProviders.fromString("""
                secrets { key: "one", value: "1111" }
                secrets { key: "two", value: "2222" }
                """);

        var one = provider.getSecret("one");
        Assert.assertTrue(one.isPresent());
        Assert.assertEquals("1111", one.get());

        var two = provider.getSecret("two");
        Assert.assertTrue(two.isPresent());
        Assert.assertEquals("2222", two.get());

        var three = provider.getSecret("three");
        Assert.assertTrue(three.isEmpty());
    }

    @Test
    public void parseJsonStyleProto() {
        var provider = SecretProviders.fromString("""
                secrets: [
                    { key: "one", value: "1111" },
                    { key: "two", value: "2222" }
                ]
                """);

        var one = provider.getSecret("one");
        Assert.assertTrue(one.isPresent());
        Assert.assertEquals("1111", one.get());

        var two = provider.getSecret("two");
        Assert.assertTrue(two.isPresent());
        Assert.assertEquals("2222", two.get());

        var three = provider.getSecret("three");
        Assert.assertTrue(three.isEmpty());
    }

    @Test
    public void parseGoStyleProto() {
        var provider = SecretProviders.fromString("""
                secrets: <
                  key: "one"
                  value: "1111"
                >
                secrets: <
                  key: "two"
                  value: "2222"
                >
                """);

        var one = provider.getSecret("one");
        Assert.assertTrue(one.isPresent());
        Assert.assertEquals("1111", one.get());

        var two = provider.getSecret("two");
        Assert.assertTrue(two.isPresent());
        Assert.assertEquals("2222", two.get());

        var three = provider.getSecret("three");
        Assert.assertTrue(three.isEmpty());
    }
}
