package ru.yandex.solomon.selfmon;

/**
 * @author Vladimir Gordiychuk
 */
public class AvailabilityStatus {
    public static final AvailabilityStatus AVAILABLE = new AvailabilityStatus(1.0, "");
    public static final AvailabilityStatus UNAVAILABLE = new AvailabilityStatus(0.0, "");

    /**
     * From 0 to 1 where 1 means that fully available
     */
    private final double availability;

    /**
     * Details about availability, or empty
     */
    private final String details;

    public AvailabilityStatus(double availability) {
        this(availability, "");
    }

    public AvailabilityStatus(double availability, String details) {
        this.availability = availability;
        this.details = details;
    }

    public double getAvailability() {
        return availability;
    }

    public String getDetails() {
        return details;
    }

    @Override
    public String toString() {
        return "AvailabilityStatus{availability=" + availability + ", details='" + details + '\'' + '}';
    }
}
