package ru.yandex.solomon.selfmon;

import java.util.List;
import java.util.concurrent.ForkJoinPool;

import javax.annotation.Nullable;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider.SystemThreadPools;
import ru.yandex.solomon.memory.layout.MemInfoMetricSupplier;
import ru.yandex.solomon.memory.layout.MemInfoProvider;
import ru.yandex.solomon.memory.layout.MemoryBySubsystem;
import ru.yandex.solomon.selfmon.ng.JvmMon;
import ru.yandex.solomon.selfmon.ng.NettyMon;
import ru.yandex.solomon.selfmon.ng.ProcSelfMon;
import ru.yandex.solomon.selfmon.ng.VersionMon;

/**
 * @author alexlovkov
 */
@Configuration
public class GeneralMonitoringContext {

    @Bean
    public MetricRegistry metricsRegistry(ThreadPoolProvider tpProvider) {
        MetricRegistry registry = MetricRegistry.root();

        JvmMon.addAllMetrics(registry);
        addThreadPoolMetrics(tpProvider, registry);

        VersionMon.addAllMetrics(registry);
        NettyMon.addAllocatorMetrics(registry);
        ProcSelfMon.addCpuTimeMetrics(registry);
        ProcSelfMon.addMemoryMetrics(registry);
        ProcSelfMon.addThreadsMetrics(registry);

        return registry;
    }

    @Bean
    public MemInfoMetricSupplier provider(@Nullable List<MemInfoProvider> providers) {
        return new MemInfoMetricSupplier(providers);
    }

    @Bean
    public MemInfoProvider fakeMemInfoProvider() {
        return MemoryBySubsystem::new;
    }

    private void addThreadPoolMetrics(ThreadPoolProvider tpProvider, MetricRegistry registry) {
        for (String name : tpProvider.getKnownNames()) {
            if (SystemThreadPools.IO.getName().equals(name)) {
                JvmMon.addExecutorMetrics(name, tpProvider.getIOExecutor(), registry);
            } else if (SystemThreadPools.SCHEDULER.getName().equals(name)) {
                JvmMon.addExecutorMetrics(name, tpProvider.getSchedulerExecutorService(), registry);
            } else {
                JvmMon.addExecutorMetrics(name, tpProvider.getExecutorService(name, "unknown"), registry);
            }
        }
        JvmMon.addExecutorMetrics("CommonFJP", ForkJoinPool.commonPool(), registry);
    }
}
