package ru.yandex.solomon.selfmon.counters;

import java.util.EnumMap;
import java.util.Map;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Counter;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;


/**
 * @author Sergey Polovko
 */
public class EnumMetrics {
    private EnumMetrics() {}

    public static <E extends Enum<E>> EnumMap<E, Counter> counters(
        Class<E> enumClass,
        MetricRegistry registry,
        String metricName,
        String labelName)
    {
        EnumMap<E, Counter> map = new EnumMap<>(enumClass);
        for (E e : enumClass.getEnumConstants()) {
            map.put(e, registry.counter(metricName, Labels.of(labelName, e.name())));
        }
        return map;
    }

    public static <E extends Enum<E>> EnumMap<E, Rate> rates(
        Class<E> enumClass,
        MetricRegistry registry,
        String metricName,
        String labelName)
    {
        EnumMap<E, Rate> map = new EnumMap<>(enumClass);
        for (E e : enumClass.getEnumConstants()) {
            map.put(e, registry.rate(metricName, Labels.of(labelName, e.name())));
        }
        return map;
    }

    public static <E extends Enum<E>> EnumMap<E, GaugeInt64> gaugesInt64(
        Class<E> enumClass,
        MetricRegistry registry,
        String metricName,
        String labelName)
    {
        EnumMap<E, GaugeInt64> map = new EnumMap<>(enumClass);
        for (E e : enumClass.getEnumConstants()) {
            map.put(e, registry.gaugeInt64(metricName, Labels.of(labelName, e.name())));
        }
        return map;
    }

    public static <E extends Enum<E>> void combineCounters(Class<E> enumClass, Map<E, Counter> r, Map<E, Counter> l) {
        for (E e : enumClass.getEnumConstants()) {
            r.get(e).combine(l.get(e));
        }
    }

    public static <E extends Enum<E>> void combineRates(Class<E> enumClass, Map<E, Rate> r, Map<E, Rate> l) {
        for (E e : enumClass.getEnumConstants()) {
            r.get(e).combine(l.get(e));
        }
    }
}
