package ru.yandex.solomon.selfmon.executors;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executor;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.meter.Meter;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class CpuMeasureExecutor implements Executor {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    static {
        threadMXBean.setThreadCpuTimeEnabled(true);
    }

    private final Meter utimeNanos;
    private final Executor executor;

    public CpuMeasureExecutor(Meter utimeNanos, Executor executor) {
        this.utimeNanos = utimeNanos;
        this.executor = executor;
    }

    @Override
    public void execute(Runnable command) {
        executor.execute(new CpuMeasureRunnable(command, utimeNanos));
    }

    /**
     * CPU MEASURE RUNNABLE
     */
    private static final class CpuMeasureRunnable implements Runnable {
        private final Runnable runnable;
        private final Meter utimeNanos;

        public CpuMeasureRunnable(Runnable runnable, Meter utimeNanos) {
            this.runnable = runnable;
            this.utimeNanos = utimeNanos;
        }

        @Override
        public void run() {
            long startNanos = threadMXBean.getCurrentThreadCpuTime();
            try {
                runnable.run();
            } finally {
                long stopNanos = threadMXBean.getCurrentThreadCpuTime();
                utimeNanos.mark(stopNanos - startNanos);
            }
        }
    }
}
