package ru.yandex.solomon.selfmon.failsafe;

import java.util.concurrent.atomic.AtomicLong;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class DefaultInFlightLimiter implements InFlightLimiter {
    private final AtomicLong inflight = new AtomicLong(0);
    private final long maxInflight;

    public DefaultInFlightLimiter(long maxInflight) {
        this.maxInflight = maxInflight;
    }

    @Override
    public boolean tryIncInFlight() {
        long current;
        do {
            current = inflight.get();
            if (current >= maxInflight) {
                return false;
            }
        } while (!inflight.compareAndSet(current, current + 1));
        return true;
    }

    @Override
    public void decInFlight() {
        inflight.getAndDecrement();
    }

    public void reset() {
        inflight.set(0);
    }
}
