package ru.yandex.solomon.selfmon.failsafe;

/**
 * @author Vladimir Gordiychuk
 */
public final class NoOpCircuitBreaker implements CircuitBreaker {
    public static final NoOpCircuitBreaker INSTANCE = new NoOpCircuitBreaker();

    private NoOpCircuitBreaker() {
    }

    @Override
    public void markSuccess() {
    }

    @Override
    public void markFailure() {
    }

    @Override
    public boolean attemptExecution() {
        return true;
    }

    @Override
    public String getSummary() {
        return "";
    }

    @Override
    public Status getStatus() {
        return Status.CLOSED;
    }
}
