package ru.yandex.solomon.selfmon.http;

import java.util.concurrent.ConcurrentHashMap;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.AsyncMetrics;

/**
 * @author Vladimir Gordiychuk
 */
public class HttpClientMetrics {
    private final ConcurrentHashMap<String, Endpoint> endpoints = new ConcurrentHashMap<>();
    private final MetricRegistry registry;

    public HttpClientMetrics(String client, MetricRegistry registry) {
        this.registry = registry.subRegistry("client", client);
    }

    public Endpoint endpoint(String path) {
        var result = endpoints.get(path);
        if (result != null) {
            return result;
        }
        result = new Endpoint(path, registry);
        var prev = endpoints.putIfAbsent(path, result);
        if (prev != null) {
            return prev;
        }
        return result;
    }

    public static class Endpoint {
        private final MetricRegistry reg;
        public final AsyncMetrics callMetrics;

        Endpoint(String endpoint, MetricRegistry registry) {
            this.reg = registry.subRegistry("endpoint", endpoint);
            this.callMetrics = new AsyncMetrics(this.reg, "http.client.call");
        }

        public void incStatus(int statusCode) {
            reg.rate("http.client.call.status", Labels.of("status", String.valueOf(statusCode))).inc();
        }
    }
}
