package ru.yandex.solomon.selfmon.mon;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.monlib.metrics.CompositeMetricSupplier;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.encode.MetricFormat;
import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;


/**
 * @author checat
 * @author Sergey Polovko
 */
@RestController
public class SelfMetricsController {

    @Autowired
    private List<MetricSupplier> suppliers;

    @RequestMapping({ "/metrics" })
    public ResponseEntity<byte[]> metrics(
        @RequestParam(value = "format", defaultValue = "UNKNOWN") MetricFormat format,
        @RequestParam(value = "compression", defaultValue = "NONE") CompressionAlg compression,
        ServerHttpRequest request)
    {
        return HttpMetricRegistryEncoder.encode(new CompositeMetricSupplier(suppliers), request, format, compression);
    }
}
