package ru.yandex.solomon.selfmon.ng;

import java.util.concurrent.Executor;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.SingleThreadEventExecutor;

import ru.yandex.monlib.metrics.JvmGc;
import ru.yandex.monlib.metrics.JvmMemory;
import ru.yandex.monlib.metrics.JvmRuntime;
import ru.yandex.monlib.metrics.JvmThreads;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.netty.NettyGeneralExecutor;
import ru.yandex.solomon.selfmon.jvm.JvmAllocations;


/**
 * @author Sergey Polovko
 */
public class JvmMon {

    public static void addAllMetrics(MetricRegistry registry) {
        JvmRuntime.addMetrics(registry);
        JvmGc.addMetrics(registry);
        JvmThreads.addMetrics(registry);
        JvmMemory.addMetrics(registry);
        JvmAllocations.addMetrics(registry);
    }

    public static void addExecutorMetrics(String name, Executor executor, MetricRegistry registry) {
        if (executor instanceof EventExecutorGroup) {
            MetricRegistry tpRegistry = registry.subRegistry("threadPool", name);
            if (executor instanceof NettyGeneralExecutor) {
                NettyGeneralExecutor threadPool = (NettyGeneralExecutor) executor;
                tpRegistry.lazyGaugeInt64("jvm.threadPool.size", threadPool::getPoolSize);
                tpRegistry.lazyGaugeInt64("jvm.threadPool.maxSize", threadPool::getMaximumPoolSize);
                tpRegistry.lazyGaugeInt64("jvm.threadPool.activeThreads", threadPool::getActiveCount);
                tpRegistry.lazyRate("jvm.threadPool.submittedTasks", threadPool::getSubmittedTasks);
                tpRegistry.lazyRate("jvm.threadPool.completedTasks", threadPool::getCompletedTasks);
            } else if (executor instanceof EventLoopGroup && ((EventLoopGroup) executor).iterator().next() instanceof SingleThreadEventExecutor) {
                tpRegistry.lazyGaugeInt64("netty.threadPool.pendingTasks", () -> {
                    long pending = 0;
                    for (var eventExecutor : (EventLoopGroup) executor) {
                        var singleExecutor = (SingleThreadEventExecutor) eventExecutor;
                        pending += singleExecutor.pendingTasks();
                    }

                    return pending;
                });
            }
        } else {
            JvmThreads.addExecutorMetrics(name, executor, registry);
        }
    }
}
