package ru.yandex.solomon.selfmon.ng;

import ru.yandex.monlib.metrics.encode.text.MetricTextEncoder;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.ng.linux.ProcPidStat;
import ru.yandex.solomon.selfmon.ng.linux.SysConf;


/**
 * @author Sergey Polovko
 *
 * TODO: 1) read /proc/self/stat only once
 *       2) support macOS
 */
public class ProcSelfMon {

    private static final long clockTicksPerSecond;
    private static final long pageSizeBytes;

    static {
        clockTicksPerSecond = SysConf.sysconf("CLK_TCK", 100);
        pageSizeBytes = SysConf.sysconf("PAGE_SIZE", 4096);
    }

    public static long pagesToBytes(long pages) {
        return pages * pageSizeBytes;
    }

    public static long ticksToMillis(long ticks) {
        return ticks * 1000 / clockTicksPerSecond;
    }

    public static void addCpuTimeMetrics(MetricRegistry registry) {
        registry.lazyRate("proc.self.utimeMs", ProcSelfMon::getUtimeMs);
        registry.lazyRate("proc.self.stimeMs", ProcSelfMon::getStimeMs);
    }

    public static void addMemoryMetrics(MetricRegistry registry) {
        registry.lazyGaugeInt64("proc.self.rssBytes", ProcSelfMon::getRssBytes);
    }

    public static void addThreadsMetrics(MetricRegistry registry) {
        registry.lazyGaugeInt64("proc.self.threads", () -> ProcPidStat.readProcSelfStat().getNumThreads());
    }

    public static long getRssBytes() {
        return pagesToBytes(ProcPidStat.readProcSelfStat().getRss());
    }

    public static long getUtimeMs() {
        return ticksToMillis(ProcPidStat.readProcSelfStat().getUtime());
    }

    public static long getStimeMs() {
        return ticksToMillis(ProcPidStat.readProcSelfStat().getStime());
    }

    // self test
    public static void main(String[] args) {
        MetricRegistry registry = new MetricRegistry();
        addCpuTimeMetrics(registry);
        addMemoryMetrics(registry);
        addThreadsMetrics(registry);
        try (MetricTextEncoder e = new MetricTextEncoder(System.out, true)) {
            registry.accept(0, e);
        }
    }
}
