package ru.yandex.solomon.selfmon.ng;

import java.util.Optional;

import ru.yandex.library.svnversion.VcsVersion;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class VersionMon {
    private static final VcsVersion VCS = new VcsVersion(VersionMon.class);

    private static Optional<String> getSvnRevision() {
        int revision = VCS.getProgramSvnRevision();
        if (revision < 0) {
            return Optional.empty();
        }
        return Optional.of("" + revision);
    }

    private static Optional<String> getArcRevision() {
        int revision = VCS.getArcadiaPatchNumer();
        if (revision < 0) {
            return Optional.empty();
        }
        if (VCS.getProgramHash().isEmpty()) {
            return Optional.of(revision + ".unknown");
        }
        return Optional.of(revision + "." + VCS.getProgramHash());
    }

    public static void addAllMetrics(MetricRegistry registry) {
        String revStr = getSvnRevision().orElse(getArcRevision().orElse("undefined"));
        registry.lazyGaugeInt64("version", Labels.of("revision", revStr), () -> 1);
    }
}
