package ru.yandex.solomon.selfmon.ng.linux;

import java.util.OptionalLong;

import javax.annotation.Nonnull;

import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.exec.ExecUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class SysConf {

    public static long sysconf(@Nonnull String name, long defaultValue) {
        Validate.notEmpty(name);
        try {
            ExecResult result = ExecUtils.executeGrabbingOutput("getconf", name);
            if (result.getCode() != 0) {
                return defaultValue;
            }

            String stdout = result.getStdout();
            OptionalLong value = stdout.lines()
                .mapToLong(Long::parseLong)
                .findFirst();
            return value.orElse(defaultValue);
        } catch (Exception t) {
            return defaultValue;
        }
    }
}
