package ru.yandex.solomon.selfmon.trace;

import java.util.function.BiConsumer;

import io.opentracing.Span;
import io.opentracing.Tracer;

/**
 * @author Vladimir Gordiychuk
 */
public class SpanAwareBiConsumer<T, U> implements BiConsumer<T, U> {
    private final Tracer tracer;
    private final Span span;
    private final BiConsumer<? super T, ? super U> consumer;

    public SpanAwareBiConsumer(Tracer tracer, Span span, BiConsumer<? super T, ? super U> consumer) {
        this.tracer = tracer;
        this.span = span;
        this.consumer = consumer;
    }

    @Override
    public void accept(T t, U u) {
        try (var scope = tracer.activateSpan(span)) {
            consumer.accept(t, u);
        }
    }
}
