package ru.yandex.solomon.selfmon.trace;

import java.util.function.BiFunction;

import io.opentracing.Span;
import io.opentracing.Tracer;

/**
 * @author Vladimir Gordiychuk
 */
public class SpanAwareBiFunction<T, U, V> implements BiFunction<T, U, V> {
    private final Tracer tracer;
    private final Span span;
    private final BiFunction<? super T, ? super U, ? extends V> fn;

    public SpanAwareBiFunction(Tracer tracer, Span span, BiFunction<? super T, ? super U, ? extends V> fn) {
        this.tracer = tracer;
        this.span = span;
        this.fn = fn;
    }

    @Override
    public V apply(T t, U u) {
        try (var scope = tracer.activateSpan(span)) {
            return fn.apply(t, u);
        }
    }
}
