package ru.yandex.solomon.selfmon.trace;

import java.util.function.Consumer;

import io.opentracing.Span;
import io.opentracing.Tracer;

/**
 * @author Vladimir Gordiychuk
 */
public class SpanAwareConsumer<T> implements Consumer<T> {
    private final Tracer tracer;
    private final Span span;
    private final Consumer<? super T> consumer;

    public SpanAwareConsumer(Tracer tracer, Span span, Consumer<? super T> consumer) {
        this.tracer = tracer;
        this.span = span;
        this.consumer = consumer;
    }

    @Override
    public void accept(T t) {
        try (var scope = tracer.activateSpan(span)) {
            consumer.accept(t);
        }
    }
}
