package ru.yandex.solomon.selfmon.trace;

import java.util.function.Function;

import io.opentracing.Span;
import io.opentracing.Tracer;

/**
 * @author Vladimir Gordiychuk
 */
public class SpanAwareFunction<T, R> implements Function<T, R> {
    private final Tracer tracer;
    private final Span span;
    private final Function<? super T, ? extends R> fn;

    public SpanAwareFunction(Tracer tracer, Span span, Function<? super T, ? extends R> fn) {
        this.tracer = tracer;
        this.span = span;
        this.fn = fn;
    }

    @Override
    public R apply(T t) {
        try (var scope = tracer.activateSpan(span)) {
            return fn.apply(t);
        }
    }
}
