package ru.yandex.solomon.selfmon.trace;

import io.opentracing.Span;
import io.opentracing.Tracer;

/**
 * @author Vladimir Gordiychuk
 */
public class SpanAwareRunnable implements Runnable {
    private final Tracer tracer;
    private final Span span;
    private final Runnable runnable;

    public SpanAwareRunnable(Tracer tracer, Span span, Runnable runnable) {
        this.tracer = tracer;
        this.span = span;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        try (var scope = tracer.activateSpan(span)) {
            runnable.run();
        }
    }
}
