package ru.yandex.solomon.selfmon.executors;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Sergey Polovko
 */
public class CpuMeasureExecutorTest {

    @Test
    public void nanoTime() throws InterruptedException {
        long start = System.nanoTime();
        Thread.sleep(5_000);
        long stop = System.nanoTime();

        System.out.println("duration (nanoTime): " + (stop - start));
        Assert.assertTrue((stop - start) >= TimeUnit.SECONDS.toNanos(5));
    }

    @Test
    public void currentThreadCpuTime() throws InterruptedException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        threadMXBean.setThreadCpuTimeEnabled(true);

        long start = threadMXBean.getCurrentThreadCpuTime();;
        Thread.sleep(5_000);
        long stop = threadMXBean.getCurrentThreadCpuTime();;

        System.out.println("duration (currentThreadCpuTime): " + (stop - start));
        Assert.assertTrue((stop - start) < TimeUnit.MILLISECONDS.toNanos(100));
    }
}
