package ru.yandex.solomon.selfmon.failsafe;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author Vladimir Gordiychuk
 */
public class ClockStub implements Clock {
    private final AtomicLong delta = new AtomicLong();

    public void passedTime(long value, TimeUnit unit) {
        delta.addAndGet(unit.toNanos(value));
    }

    @Override
    public long nanoTime() {
        return System.nanoTime() + delta.get();
    }
}
