package ru.yandex.solomon.selfmon.ng.linux;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.misc.jni.JniUtils;

/**
 * @author Stepan Koltsov
 */
public class ProcPidStatTest {

    @Test
    public void parse() {
        String line = "29226 (cat) R 4123 29226 4123 34821 29226 4202496 273 0 0 0 0 0 0 0 20 0 1 0" +
                " 1358751940 9121792 89 18446744073709551615 4194304 4237340" +
                " 140734242825312 140734242825312 139843438096352 0 0 0 0 0 0 0 17 13 0 0 0 0 0" +
                " 6336032 6337168 31485952 140734242830613 140734242830633 140734242830633 140734242832367 0";
        ProcPidStat procPidStat = ProcPidStat.parse(line);
        Assert.assertEquals(29226, procPidStat.getPid());
        Assert.assertEquals(1, procPidStat.getNumThreads());
        Assert.assertEquals(89, procPidStat.getRss());
        Assert.assertEquals(0, procPidStat.getUtime());
        Assert.assertEquals(0, procPidStat.getStime());
    }

    @Test
    public void bug1() {
        String line = "5053 (java) S 5048 5048 5048 0 -1 4202496 1362945 855 2 0 32163 627 0 0 20 0 267 0" +
                " 1359288462 15900581888 1069182 18446744073709551615 4194304 4196468" +
                " 140736679493136 140736679475696 140505848594760 0 0 0 16800975 18446744073709551615 0 0 17 15 0 0 0 0 0" +
                " 6293624 6294260 13926400 140736679501398 140736679501607 140736679501607 140736679501787 0";
        ProcPidStat.parse(line);
    }

    @Test
    public void readProcSelfStat() {
        if (!JniUtils.isLinux()) {
            return;
        }

        ProcPidStat.readProcSelfStat();
    }
}
